#version 330

uniform sampler2D color0Tex;
uniform sampler2D color1Tex;
uniform sampler2D lightTex;
uniform sampler2D aoTex;
uniform samplerCube glossCube;
uniform mat4 invPersp;
uniform mat4 invView;
uniform float farClip;
uniform vec4 fogColor;
uniform vec4 fogParams;

in vec4 uv;

out vec4 oColor;

vec4 screenToProj(vec2 iCoord)
{
    return vec4(2.0f * vec2(iCoord.x, 1.0f - iCoord.y) - 1, 0.0, 1.0);
}

vec3 depthToPosition(float iDepth, vec4 iPosProj)
{
    vec3 vPosView = (invPersp * iPosProj).xyz;
    vec3 vViewRay = vec3(vPosView.xy * (farClip / vPosView.z), farClip);
    vec3 vPosition = vViewRay * iDepth;
    return vPosition;
}

vec3 decodeNormal(vec2 enc)
{
    vec2 fenc = enc*4 - 2;
    float f = dot(fenc, fenc);
    float g = sqrt(1 - f/4);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1 - f/2;
    return n;
}

void main()
{
	vec4 normalDepth = textureLod(color0Tex, uv.xy, 0);
	
	vec4 diffuse_spec = textureLod(color1Tex, uv.xy, 0);
	vec4 light = textureLod(lightTex, uv.xy, 0);
	float ao = textureLod(aoTex, uv.xy, 0).r;
	
	vec4 projSpacePos = screenToProj(uv.xy);
	vec3 viewSpacePos = depthToPosition(normalDepth.z, projSpacePos);
	
	mat3 rotN = mat3( -1, 0, 0, 0, 0, -1, 0, -1, 0 );
	vec3 N = decodeNormal(normalDepth.xy);
	vec3 EyeDir = normalize(-viewSpacePos.xyz);
	vec3 ReflectDir = reflect(EyeDir, N);
	ReflectDir = rotN*mat3(invView)*ReflectDir;
	
	float Rim = clamp(pow(1 - abs(dot(EyeDir, N)), 2)*0.5, 0.0, 1.0);
	
	vec3 lightColor = light.rgb*2.0*(1.0 - ao);
	float emissive = 0.0;
	if((int(normalDepth.w) & 4) != 0) {
		emissive = fract(normalDepth.w);
		lightColor = mix(lightColor, vec3(1.0), emissive);
	}
	
	vec3 litColor = diffuse_spec.rgb*lightColor + Rim*0.1;
	
	litColor += diffuse_spec.w*(light.a + (0.1 + max(diffuse_spec.w - 0.9, 0.0)*2)*texture(glossCube, ReflectDir).rgb);
	
	float fogDistance = clamp(length(viewSpacePos) - fogParams.y, 0.0, farClip);
	float fogFactor = clamp(1.0 - 1.0/exp2(fogDistance*fogParams.x), 0.0, 1.0);
	
	oColor = vec4(mix(litColor, fogColor.rgb, fogFactor), emissive);
}
